<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Client extends Model 
{

    protected $table = 'clients';
    public $timestamps = true;
    protected $fillable = array('name', 'email', 'birth_date', 'city_id', 'phone', 'passwoed', 'is_active');

    public function requests()
    {
        return $this->hasMany('App\Models\DonationRequest');
    }

    public function favourites()
    {
        return $this->belongsToMany('App\Models\Post');
    }

    public function report()
    {
        return $this->hasMany('App\Models\Report');
    }

    public function contacts()
    {
        return $this->hasMany('App\Models\Contact');
    }

    public function bloodTypes()
    {
        return $this->belongsToMany('App\BloodType');
    }

}